//=============================================================================
// MedKit.
//=============================================================================
class InstaHealVial extends DeusExPickup;

#exec MESH IMPORT MESH=InstaHeal ANIVFILE=MODELS\InstaHeal_a.3d DATAFILE=MODELS\InstaHeal_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=InstaHeal X=0 Y=0 Z=100 PITCH=0 ROLL=64 YAW=0

#exec MESH SEQUENCE MESH=InstaHeal SEQ=All              STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=InstaHeal SEQ=InstaHeal STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW   MESHMAP=InstaHeal MESH=InstaHeal
#exec MESHMAP SCALE MESHMAP=InstaHeal X=0.01933655625 Y=0.01933655625 Z=0.01933655625

#exec TEXTURE IMPORT FILE="Textures\SARed.pcx"	NAME="IHRed"	GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\WeaponBoxSilverAlloy.pcx"	NAME="IHSilver"				GROUP="Icons" MIPS=Off
#exec TEXTURE IMPORT FILE="Textures\SAGray.pcx"	NAME="IHGray"	GROUP="Icons" MIPS=Off

#exec MESHMAP SETTEXTURE MESHMAP=InstaHeal NUM=0 TEXTURE=IHRed
#exec MESHMAP SETTEXTURE MESHMAP=InstaHeal NUM=1 TEXTURE=IHGray
#exec MESHMAP SETTEXTURE MESHMAP=InstaHeal NUM=2 TEXTURE=IHSilver


var int healAmount;

var const int HealAmounts[5];
var const String Ranks[5];

var travel int Rank;

function PostBeginPlay()
{
 Super.PostBeginPlay();
 
 Rank = Rand(5);
 
 UpdateStats();
}

function TravelPostAccept()
{
 Super.TravelPostAccept();
 
 UpdateStats();
}

function UpdateStats()
{
 HealAmount = HealAmounts[Rank];
 ItemName = "|cbc3d41"$Ranks[Rank]$"Insta-Heal Vial";
}

// ----------------------------------------------------------------------
auto state Pickup
{
 function Frob(Actor A, Inventory B)
 {
  local DeusExPlayer player;

  player = DeusExPlayer(A);

   if (player != None)
   {
    player.HealPlayer(healAmount, False);
   
    WipeAcid();
    player.StopPoison();
    player.ExtinguishFire();
    player.drugEffectTimer = 0;
    PlaySound(sound'MedicalHiss');
   }
  
  Destroy();
 }
}

function WipeAcid()
{
 local AcidMold M;
 
 forEach AllActors(class'AcidMold', M)
 {
  if (M.Moldee == Owner) M.Destroy();
 }
}

simulated function bool TestMPBeltSpot(int BeltSpot)
{
   return (BeltSpot == 9);
}

// ----------------------------------------------------------------------
// ----------------------------------------------------------------------

defaultproperties
{
     healAmount=25
     //maxCopies=1
     //bCanHaveMultipleCopies=True
     bActivatable=True
     ItemName="|cbc3d41Insta-Heal Vial"
     PlayerViewOffset=(X=30.000000,Z=-12.000000)
     PlayerViewMesh=LodMesh'InstaHeal'
     PickupViewMesh=LodMesh'InstaHeal'
     ThirdPersonMesh=LodMesh'InstaHeal'
     LandSound=Sound'DeusExSounds.Generic.PlasticHit2'
     Icon=Texture'DeusExUI.Icons.BeltIconMedKit'
     largeIcon=Texture'DeusExUI.Icons.LargeIconMedKit'
     largeIconWidth=39
     largeIconHeight=46
     Description="ERROR"
     beltDescription="ERR"
     Mesh=LodMesh'InstaHeal'
     PickupViewScale=0.50000
     CollisionRadius=7.500000
     CollisionHeight=2.000000
     Mass=10.000000
     Buoyancy=8.000000
     InvSlotsX=0
     InvSlotsY=0
     Ranks(0)="Minor "
     Ranks(1)="Light "
     Ranks(2)=""
     Ranks(3)="Greater "
     Ranks(4)="Grand "
     HealAmounts(0)=15
     HealAmounts(1)=25
     HealAmounts(2)=40
     HealAmounts(3)=55
     HealAmounts(4)=70
}
